<?php
/**
 * Template Name: Single Page Template - Article
 *
 * Description: A page template that provides a key component of WordPress as a CMS
 * by meeting the need for a carefully crafted introductory page. The front page template
 * in Twenty Twelve consists of a page content area for adding text, images, video --
 * anything you'd like -- followed by front-page-only widgets in one or two columns.
 *
 * @package WordPress
 * @subpackage Twenty_Twelve
 * @since Twenty Twelve 1.0
 */

get_header(); ?>

	<div id="primary" class="site-content column">
		<div id="content" role="main">
	<article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>

		<header class="entry-header">


			<h1 class="entry-title"><?php the_title(); ?></h1>

		</header><!-- .entry-header -->
        
        
        <div class="entry-content">
			<?php while ( have_posts() ) : the_post(); ?>
				<?php the_content( __( '', 'twentytwelve' ) ); ?>
			<?php endwhile; // end of the loop. ?>
        
<div class="email-wrapper">
<?php if( have_rows('article') ): ?>
	<?php while( have_rows('article') ): the_row(); 

		// vars
		$title = get_sub_field('article_title');
		$subject = get_sub_field('article_subject');
        $text = get_sub_field('article_text');
		?>
        
       <div class="email-list articles-list">
        <p class="banner-title"><strong><?php echo $title; ?></strong></p>
                
        <label>Title:</label><input value="<?php echo $subject; ?>">
        <p class="label">Text:</p>
        <div class="textarea"><?php echo $text; ?></div>

        </div>
	<?php endwhile; ?>
<?php endif; ?>
</div>

</div>
</article>

		</div><!-- #content -->
	</div><!-- #primary -->

<script type="text/javascript">
$(document).ready(function() {
		$(".fancybox").fancybox();
	});
	
jQuery('#type').on("input", function() {
    jQuery(".change").text(this.value);
});
  
jQuery('#hit').click(function(event) {
     var username = jQuery('#type').val();

	jQuery('.link-change a').each(function() {
     Query(this).attr("href", function(index, old) {
         return old.replace('YOURNAME', username);
      });
 });
 
 
// jQuery( ".link-change" ).wrapInner(function() {
//  return "<textarea></textarea>";
//});

});	   
</script>



<?php get_sidebar(); ?>
<?php get_footer(); ?>