<?php
/**
 * The Header template for our theme
 *
 * Displays all of the <head> section and everything up till <div id="main">
 *
 * @package WordPress
 * @subpackage Twenty_Twelve
 * @since Twenty Twelve 1.0
 */
?><!DOCTYPE html>
<!--[if IE 7]>
<html class="ie ie7" <?php language_attributes(); ?>>
<![endif]-->
<!--[if IE 8]>
<html class="ie ie8" <?php language_attributes(); ?>>
<![endif]-->
<!--[if !(IE 7) & !(IE 8)]><!-->
<html <?php language_attributes(); ?>>
<!--<![endif]-->
<head>
<meta charset="<?php bloginfo( 'charset' ); ?>" />
<meta name="viewport" content="width=device-width" />
<meta name="robots" content="noindex, nofollow, noarchive">
<title><?php wp_title( '|', true, 'right' ); ?></title>
<link rel="profile" href="http://gmpg.org/xfn/11" />
<link rel="pingback" href="<?php bloginfo( 'pingback_url' ); ?>" />
<!--[if lt IE 9]>
<script src="<?php echo get_template_directory_uri(); ?>/js/html5.js" type="text/javascript"></script>
<![endif]-->
<?php wp_head(); ?>
<link href="//maxcdn.bootstrapcdn.com/font-awesome/4.2.0/css/font-awesome.min.css" rel="stylesheet">
<link rel='stylesheet' href='<?php echo get_template_directory_uri(); ?>/diet-style.css' type='text/css' media='all' />
<link href="/text-page/fonts/fonts.css" rel="stylesheet" type="text/css">
<link rel='stylesheet' href='<?php echo get_template_directory_uri(); ?>/fancybox/jquery.fancybox.css' media='screen'/>
<style type="text/css">
#hoverNav {
    top: 0;
    left: 0;
    height: 1px;
    width: 100%;
    z-index: 2;
    position: absolute;
}
#prevLink, #nextLink {
    width: 20%;
}
.wpcf7-form button, .wpcf7-form input, .wpcf7-form textarea {
    line-height: normal;
    max-width: 100%;
}
</style>
<script language='javaScript' src='<?php echo get_template_directory_uri(); ?>/js/jquery.min.js' type='text/javascript'></script>
<script language='javaScript' src='<?php echo get_template_directory_uri(); ?>/fancybox/jquery.fancybox.pack.js' type='text/javascript'></script>
</head>

<body <?php body_class(); ?>>
<div class="top-blue-nav">               
<div class="site site-reset clearfix">
		<hgroup>
			<h1 class="site-title"><a href="<?php echo esc_url( home_url( '/' ) ); ?>" title="<?php echo esc_attr( get_bloginfo( 'name', 'display' ) ); ?>" rel="home"><img src='<?php echo get_template_directory_uri(); ?>/images/ed-logo.png' /></a></h1>
		</hgroup>
        <nav id="nav-main" class="main-navigation">
			<?php wp_nav_menu( array( 'theme_location' => 'primary', 'menu_class' => 'nav-menu' ) ); ?>
		</nav><!-- #site-navigation -->
        
    <div id="nav-trigger">
    <span class="fa fa-align-justify"></span>
</div>
<nav id="nav-mobile"></nav>

</div>
</div>

<header id="masthead" class="site-header" role="banner">
<div class="site site-reset">
	<br>
		 <?php get_sidebar( 'header'); ?>
</div>
	</header><!-- #masthead -->


<div id="page" class="hfeed site">

	<div id="main" class="wrapper">
<style>
h2 {color: #d71135!important;}
p a {color: #d71135!important; font-weight: bold!important;}
span.link-color {color:#d71135!important;background-color:#d1d1d1!important;}
</style>